%% MBD - EcoCAR 2
%Glider Model Initialization file
%David Ord

%% Vehicle Parameters

MDL.VehicleDynamics.M = 2050;           %vehicle mass [kg]
MDL.VehicleDynamics.Mi = MDL.VehicleDynamics.M * 1.04;             %intertial mass [kg]
MDL.VehicleDynamics.c_rr = 0.01;        %coefficient of rolling resistance
MDL.VehicleDynamics.r_w = 0.324;        %wheel radius [m]
MDL.VehicleDynamics.CdA = 0.76;         %Coefficient of drag mult. with frontal area [m^2]
MDL.VehicleDynamics.rho = 1.2;          %air density [kg/m^3]
MDL.VehicleDynamics.g = 9.81;           %gravitational constant [m/s^2]
MDL.VehicleDynamics.MdlT = 30;         %simulation time [s]

%% Case Parameters

MDL.VehicleDynamics.V_i = 0;                          %initial velocity [m/s]
DriveCycle = [0 0;5 0];              %tractive effort input [N]
MDL.VehicleDynamics.grade = 0;                      %road grade [%]

sim('Glider_X2_DOrd')

v_mph = yout(:,1)*2.23694;  %convert m/s to mph

%% Plot Results
%parameters stored in matrix 'yout'
%index columns to find specific parameters
%eg. to index grade force: yout(:,5)

%1: velocity (m/s)
%2: acceleration
%3: distance
%4: tractive force
%5: grade force
%6: rolling resistance
%7: aero force
%8: road load
%9: axle torque
%10: tractive power
%11: tractive energy
%velocity in mph stored in: v_mph

figure
plot(tout,v_mph);
box on
grid on
xlabel('Time, t (s)')
ylabel('Velocity (mph)')
title('Velocity')

figure
plot(tout,yout(:,2));
box on
grid on
xlabel('Time, t (s)')
ylabel('Acceleration (m/s^2)')
title('Acceleration')

figure
plot(tout,yout(:,4));
box on
grid on
xlabel('Time, t (s)')
ylabel('Tractive Force (N)')
title('Tractive Force')

figure
plot(tout,yout(:,9));
box on
grid on
xlabel('Time, t (s)')
ylabel('Axle Torque (Nm)')
title('Axle Torque')

figure
plot(tout,yout(:,10));
box on
grid on
xlabel('Time, t (s)')
ylabel('Tractive Power (kW)')
title('Tractive Power')

figure
plot(tout,yout(:,11));
box on
grid on
xlabel('Time, t (s)')
ylabel('Tractive Energy (kWh)')
title('Tractive Energy')

figure
plot(tout,yout(:,8));
box on
grid on
xlabel('Time, t (s)')
ylabel('Inertial Load (N)')
title('Inertial Load')

