%% MBD - EcoCAR 2
%Driver Model Initialization file
%David Ord

%% Vehicle Parameters

MDL.VehicleDynamics.M = 2050;           %vehicle mass [kg]
MDL.VehicleDynamics.Mi = 1.04*MDL.VehicleDynamics.M;        %intertial mass [kg]
MDL.VehicleDynamics.c_rr = 0.01;        %coefficient of rolling resistance
MDL.VehicleDynamics.CdA = 0.76;         %Coefficient of drag mult. with frontal area [m^2]
MDL.VehicleDynamics.rho = 1.2;          %air density [kg/m^3]
MDL.VehicleDynamics.r_w = 0.324;        %wheel radius [m]
MDL.VehicleDynamics.grade = 0;          %road grade [%]
MDL.VehicleDynamics.g = 9.81;           %gravitational constant [m/s^2]
MDL.VehicleDynamics.V_i = 0;            %initial velocity [m/s]

%% Motor Model Parameters

MDL.MotorModel.C0 = 600;
MDL.MotorModel.C1 = 0.02;
MDL.MotorModel.C2 = 0.0000015;
MDL.MotorModel.MaxTrqOut = 300;
MDL.MotorModel.rw = 0.324;        %wheel radius [m]

MDL.MotorModel.MaxPwrOut = 125000;

%% Battery Model Parameters

MDL.BatteryModel.AccyLoad = 600;
MDL.BatteryModel.Voc = 340;
MDL.BatteryModel.Rint = 0.08;
MDL.BatteryModel.Ecap = 18.8;
MDL.BatteryModel.SOCi = 0.95;

%% Driveline Model Parameters

MDL.DrivelineModel.G = 7.17;
MDL.DrivelineModel.C0 = 600;
MDL.DrivelineModel.C1 = 0.012;
MDL.DrivelineModel.C2 = 0.00000049;

MDL.DrivelineModel.Ftr_max = 8000;

%% Driver Model Parameters

MDL.DriverModel.Kp = 200;
MDL.DriverModel.Ki = 10;
MDL.DriverModel.Kd = 0;

MDL.DriverModel.BrakeGain = 100;
MDL.DriverModel.Ftr_Max = 8000;
MDL.DriverModel.Ptr_Max = 110000;

%% Load Drive Cycles from Excel File

MDL.DriveCycle.UDDS = xlsread('DriveCycles_Scaled.xls',2,'A4:B1376');
MDL.DriveCycle.DC505 = xlsread('DriveCycles_Scaled.xls',3,'A4:B509');
MDL.DriveCycle.FTP = xlsread('DriveCycles_Scaled.xls',4,'A4:B2481');
MDL.DriveCycle.HWFET = xlsread('DriveCycles_Scaled.xls',5,'A4:B769');
MDL.DriveCycle.US06 = xlsread('DriveCycles_Scaled.xls',6,'A4:B600');
MDL.DriveCycle.US06C = xlsread('DriveCycles_Scaled.xls',7,'A4:B236');
MDL.DriveCycle.US06H = xlsread('DriveCycles_Scaled.xls',9,'A4:B374');

%% Run and Plot UDDS results

MDL.VehicleDynamics.T = length(MDL.DriveCycle.UDDS);
DriveCycle = MDL.DriveCycle.UDDS;

sim('NTER_Assign4PL_SOLUTION')

figure
hold on
grid on
box on
plot(0:1:MDL.VehicleDynamics.T-1, MDL.DriveCycle.UDDS(:,2),'r','LineWidth',2)
plot(tout,yout(:,7)*2.23694)    %m/s to mph
title('Velocity vs. Time')
xlabel('Time, t (s)')
ylabel('Velocity, V (mph)')

figure
scatter(yout(:,7)*3.6,yout(:,10)/1000,'.')
grid on
box on
title('Tractive Force vs. Vehicle Speed')
xlabel('Vehicle Speed, V (kph)')
ylabel('Tractive Force, Ftr (kN)')

figure
plot(tout,yout(:,1))
grid on
box on
title('SOC vs. Time')
xlabel('Time, t (s)')
ylabel('SOC (%)')

figure
scatter(yout(:,7),yout(:,6),'.')
grid on
box on
title('Motor Power vs. Vehicle Speed')
xlabel('Vehicle Speed (m/s)')
ylabel('Motor Power Out (W)')
