%% MBD - EcoCAR 2
%Series PHEV Model Initialization file
%David Ord

%% Vehicle Parameters

MDL.VehicleDynamics.M = 2050;           %vehicle mass [kg]
MDL.VehicleDynamics.Mi = 1.04*MDL.VehicleDynamics.M;        %intertial mass [kg]
MDL.VehicleDynamics.c_rr = 0.01;        %coefficient of rolling resistance
MDL.VehicleDynamics.r_w = 0.324;        %wheel radius [m]
MDL.VehicleDynamics.CdA = 0.76;         %Coefficient of drag mult. with frontal area [m^2]
MDL.VehicleDynamics.rho = 1.2;          %air density [kg/m^3]
MDL.VehicleDynamics.grade = 0;          %road grade [%]
MDL.VehicleDynamics.g = 9.81;           %gravitational constant [m/s^2]
MDL.VehicleDynamics.V_i = 0;            %initial velocity [m/s]

%% Motor Model Parameters

MDL.MotorModel.C = 600;
MDL.MotorModel.kc = 0.12;
MDL.MotorModel.ki = 0.01;
MDL.MotorModel.kw = 1.2e-5;
MDL.MotorModel.MaxTrqOut = 300;

MDL.MotorModel.rw = 0.324;        %wheel radius [m]

MDL.MotorModel.MaxPwrOut = 125000;

%% Battery Model Parameters

MDL.BatteryModel.AccyLoad = 600;
MDL.BatteryModel.Voc = 340;
MDL.BatteryModel.Rint = 0.08;
MDL.BatteryModel.Ecap = 8.8;
MDL.BatteryModel.SOCi = 0.45;

%% Driveline Model Parameters

MDL.DrivelineModel.C0 = 600;
MDL.DrivelineModel.C1 = 0.012;
MDL.DrivelineModel.C2 = 0.00000049;
MDL.DrivelineModel.G = 7.17;
MDL.DrivelineModel.Spinloss = 3.6;
MDL.DrivelineModel.rw = 0.324;        %wheel radius [m]

MDL.DrivelineModel.Ftr_max = 8000;

MDL.Driveline.SpinLoss = 3;             % Const drieline loss [Nm]
MDL.Driveline.G = 7.17;                 % Gear ratio
MDL.Driveline.rw = 0.324;               % Wheel radius [m]

%% Generator Model Parameters

MDL.GeneratorModel.C0 = 600;
MDL.GeneratorModel.C1 = 0.033;
MDL.GeneratorModel.C2 = 0.0008/1000;

MDL.GeneratorModel.PeakMechPwr = 50000;
MDL.GeneratorModel.ContMechPwr = 25000;

%% Driver Model Parameters

MDL.DriverModel.Kp = 350;
MDL.DriverModel.Ki = 0;
MDL.DriverModel.Kd = 0;

MDL.DriverModel.BrakeGain = 100;
MDL.DriverModel.Ftr_Max = 8000;
MDL.DriverModel.Ptr_Max = 110000;

%% Brake System Parameters

MDL.BrakeSys.MaxBrakeForce = 10000;
MDL.BrakeSys.RegenFraction = 0.55;

%% Engine Model Parameters

MDL.EngineModel.C0 = 6760;                   % Const Loss [W]
MDL.EngineModel.C1 = 1.32;                   % P-Proportional Loss [-]
MDL.EngineModel.C2 = 0.0042/1000;            % P^2-Proportional Loss [1/W]
MDL.EngineModel.LHV = 44400;                 % LHV of Fuel [J/g]
LHV = MDL.EngineModel.LHV;
MDL.EngineModel.MaxOutPwr = 130000;          % Maximum Engine Output Power [W]
MDL.EngineModel.EngStartEnergy = 0;          % Fuel penalty for an engine start [g]
MDL.EngineModel.AccyLoad = 600;

%% Set up Hybrid Controller

MDL.HVSCModel.TargetSOC = 0.45;       % Target SOC for the hybrid controller [%]
MDL.HVSCModel.SOC_gain = 100000;      % Gain for proportional SOC control

%% Load Drive Cycles from Excel File

MDL.DriveCycle.UDDS = xlsread('DriveCycles_Scaled.xls',2,'A4:B1376');
MDL.DriveCycle.DC505 = xlsread('DriveCycles_Scaled.xls',3,'A4:B509');
MDL.DriveCycle.FTP = xlsread('DriveCycles_Scaled.xls',4,'A4:B2481');
MDL.DriveCycle.HWFET = xlsread('DriveCycles_Scaled.xls',5,'A4:B769');
MDL.DriveCycle.US06 = xlsread('DriveCycles_Scaled.xls',6,'A4:B600');
MDL.DriveCycle.US06C = xlsread('DriveCycles_Scaled.xls',7,'A4:B236');
MDL.DriveCycle.US06H = xlsread('DriveCycles_Scaled.xls',9,'A4:B374');

%% Run and Plot UDDS results

DriveCycle = MDL.DriveCycle.UDDS;
MDL.VehicleDynamics.T = length(DriveCycle);

% ChargeBalancedSim

sim('NTER_Assign5_SOLUTION')

% figure
% hold on
% grid on
% box on
% plot(0:1:MDL.VehicleDynamics.T-1, MDL.DriveCycle.UDDS(:,2),'r','LineWidth',2)
% plot(tout,yout(:,2)*2.23694)    %m/s to mph
% title('Velocity vs. Time')
% xlabel('Time, t (s)')
% ylabel('Velocity, V (mph)')

% figure
% scatter(yout(:,2)*3.6,yout(:,4)/1000,'.')
% grid on
% box on
% title('Tractive Force vs. Vehicle Speed')
% xlabel('Vehicle Speed, V (kph)')
% ylabel('Tractive Force, Ftr (kN)')

figure
plot(tout,yout(:,1))
grid on
box on
title('SOC vs. Time')
xlabel('Time, t (s)')
ylabel('SOC (%)')

% figure
% scatter(yout(:,2)*3.6,MotTrqOut,'.')
% grid on
% box on
% title('Motor Power vs. Vehicle Speed')
% xlabel('Vehicle Speed (kph)')
% ylabel('Motor Power Out (W)')

BattLoss = BattLosses(end)/1000
MotorLoss = MotorLosses(end)/1000
GenLoss = GenLosses(end)/1000
DLLoss = DLLosses(end)/1000
EngLoss = EngLosses(end)/1000
GenPower = GenPower(end)
EnergyConsump = ((yout(1,1) - yout(end,1))*MDL.BatteryModel.Ecap*1000/(yout(end,4)*0.000621))...
    + FuelEnergy(end)
% EstRange = MDL.BatteryModel.Ecap*1000/EnergyConsump
% BattEnergy = (yout(1,1)-yout(end,1))*MDL.BatteryModel.Ecap
