/*
  * File : PCAN_Init.c
 * Abstract:
 *     C-MEX S-function block for PCAN Initialization.
 *
 * References:
 *     PCANBasic.h
 *
 * Compile with:
 *     mex PCANBasic.lib PCAN_Init.c
 */

#define S_FUNCTION_NAME  PCAN_Init
#define S_FUNCTION_LEVEL 2

#include "simstruc.h"
#ifndef  MATLAB_MEX_FILE 
  #include <unistd.h>
  #include <math.h>
  #include <signal.h>
  #include <stdio.h>
  #include <stdlib.h>
  #include <fcntl.h>
  #include <string.h>
  #include <time.h>
  #include<PCANBasic.h>
#else
  #include <windows.h>
  #include "lib/PCANBasic.h"
  #include "mex.h"
#endif 

/*================*
 * Build checking *
 *================*/


/* Function: mdlInitializeSizes ===============================================
 * Abstract:
 *   Setup sizes of the various vectors.
 */
static void mdlInitializeSizes(SimStruct *S)
{
    ssSetNumSFcnParams(S, 0);
    if (ssGetNumSFcnParams(S) != ssGetSFcnParamsCount(S)) {
        return; /* Parameter mismatch will be reported by Simulink */
    }

    if (!ssSetNumInputPorts(S, 3)) return;
    ssSetInputPortWidth(S, 0, 1);
    ssSetInputPortWidth(S, 1, 1);
    ssSetInputPortWidth(S, 2, 1);
    
    ssSetInputPortDirectFeedThrough(S, 0, 1);

    if (!ssSetNumOutputPorts(S,1)) return;
    ssSetOutputPortWidth(S, 0, 1);//DYNAMICALLY_SIZED);

    ssSetNumSampleTimes(S, 1);

    /* Take care when specifying exception free code - see sfuntmpl_doc.c */
    ssSetOptions(S,
                 SS_OPTION_WORKS_WITH_CODE_REUSE |
                 SS_OPTION_EXCEPTION_FREE_CODE |
                 SS_OPTION_USE_TLC_WITH_ACCELERATOR);
}


/* Function: mdlInitializeSampleTimes =========================================
 * Abstract:
 *    Specifiy that we inherit our sample time from the driving block.
 */
static void mdlInitializeSampleTimes(SimStruct *S)
{
    ssSetSampleTime(S, 0, 0.02);
    ssSetOffsetTime(S, 0, 0.0);
    ssSetModelReferenceSampleTimeDefaultInheritance(S); 
}

/* Function: mdlOutputs =======================================================
 * Abstract:
 *    
 */
static void mdlOutputs(SimStruct *S, int_T tid)
{
    int_T             ret=0;
    InputRealPtrsType Eingabe = ssGetInputPortRealSignalPtrs(S,0);
    real_T            *y    = ssGetOutputPortRealSignal(S,0);
    #ifndef  MATLAB_MEX_FILE 
		// running on HW
		printf("linux\n");
		ret = CAN_Initialize((int)*Eingabe[0],(int)*Eingabe[1], (int)*Eingabe[2],0,0);
   
		*(y) = ret;
    #else
		//ssPrintf("windows\n");
     
		/* If a global Atom is placed from previous session delete - only implemented for the MatLab Version */
		ATOM tempAtom;
		tempAtom=GlobalFindAtom("PCANLight_USB_Client");
		if(tempAtom!=0)// not the first time - something went wrong in the past..
		{
		   GlobalDeleteAtom(tempAtom);
		}
		ret = CAN_Initialize((int)*Eingabe[0],(int)*Eingabe[1], (int)*Eingabe[2],0,0);
		*(y) = ret;
    #endif
}


/* Function: mdlTerminate =====================================================
 * Abstract:
 *    No termination needed, but we are required to have this routine.
 */
static void mdlTerminate(SimStruct *S)
{
}



#ifdef  MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif
