/*
  * File : PCAN_Read.c
 * Abstract:
 *     C-MEX S-function block for PCAN Read from CAN bus.
 *
 * References:
 *     PCANBasic.h
 *
 * Compile with:
 *     mex PCANBasic.lib PCAN_Read.c
 */


#define S_FUNCTION_NAME  PCAN_Read
#define S_FUNCTION_LEVEL 2
#include "simstruc.h"
#ifndef  MATLAB_MEX_FILE 
  #include <unistd.h>
  #include <math.h>
  #include <signal.h>
  #include <stdio.h>
  #include <stdlib.h>
  #include <fcntl.h>
  #include <string.h>
  #include <time.h>
  #include<PCANBasic.h>
#else
  #include <windows.h>
  #include "lib/PCANBasic.h"
  #include "mex.h"
#endif 

//#define PCAN_PARAM(S) ssGetSFcnParam(S,0)
/*================*
 * Build checking *
 *================*/


/* Function: mdlInitializeSizes ===============================================
 * Abstract:
 *   Setup sizes of the various vectors.
 */
static void mdlInitializeSizes(SimStruct *S)
{
    ssSetNumSFcnParams(S, 0);
   
    if (ssGetNumSFcnParams(S) != ssGetSFcnParamsCount(S)) {
        return; /* Parameter mismatch will be reported by Simulink */
    }
     
    if (!ssSetNumInputPorts(S, 1)) return;
    ssSetInputPortWidth(S, 0, 1);
//    ssSetInputPortWidth(S, 0, DYNAMICALLY_SIZED);
    ssSetInputPortDirectFeedThrough(S, 0, 1);

    if (!ssSetNumOutputPorts(S,5)) return;
    ssSetOutputPortWidth(S, 0, 1);//DYNAMICALLY_SIZED);
    ssSetOutputPortWidth(S, 1, 1);//DYNAMICALLY_SIZED);
    ssSetOutputPortWidth(S, 2, 1);//DYNAMICALLY_SIZED);
    ssSetOutputPortWidth(S, 3, 1);//DYNAMICALLY_SIZED);
    ssSetOutputPortWidth(S, 4, 8);//DYNAMICALLY_SIZED);

    ssSetNumSampleTimes(S, 1);

    /* Take care when specifying exception free code - see sfuntmpl_doc.c */
    ssSetOptions(S,
                 SS_OPTION_WORKS_WITH_CODE_REUSE |
                 SS_OPTION_EXCEPTION_FREE_CODE |
                 SS_OPTION_USE_TLC_WITH_ACCELERATOR);
}


/* Function: mdlInitializeSampleTimes =========================================
 * Abstract:
 *    Specifiy that we inherit our sample time from the driving block.
 */
static void mdlInitializeSampleTimes(SimStruct *S)
{
    ssSetSampleTime(S, 0, 0.02);
    ssSetOffsetTime(S, 0, 0.0);
    ssSetModelReferenceSampleTimeDefaultInheritance(S); 
}

/* Function: mdlOutputs =======================================================
 * Abstract:
 *    
 */
static void mdlOutputs(SimStruct *S, int_T tid)
{
    int_T               i;
    int_T               ret;
    TPCANMsg myMsg;
    InputRealPtrsType PCAN_USBBUS = ssGetInputPortRealSignalPtrs(S,0);
    real_T *data_ptr0 = ssGetOutputPortRealSignal(S,0);
    real_T *data_ptr1 = ssGetOutputPortRealSignal(S,1);
    real_T *data_ptr2 = ssGetOutputPortRealSignal(S,2);
    real_T *data_ptr3 = ssGetOutputPortRealSignal(S,3);
    real_T *data_ptr4 = ssGetOutputPortRealSignal(S,4);
    #ifndef  MATLAB_MEX_FILE 
    // running on HW
		// printf("linux\n");
		 /* Read the CAN driver buffer */
		ret = CAN_Read((int)*PCAN_USBBUS[0],&myMsg,NULL);
		/* first entry is always the ret-value of the function */
		*(data_ptr0) = ret;  
		/* Accept only Data no Staus or RTR Msg, also check if ret value was OK */
	    if((ret == PCAN_ERROR_OK || ret == PCAN_ERROR_QRCVEMPTY) && ((myMsg.MSGTYPE==PCAN_MESSAGE_STANDARD)||(myMsg.MSGTYPE==PCAN_MESSAGE_EXTENDED)))
		{
			 *data_ptr1 = myMsg.ID;
			 *data_ptr2 = myMsg.MSGTYPE; 
			 *data_ptr3 = myMsg.LEN;
			 /* copy Data to Array */
			 for(i=0;i<myMsg.LEN;i++)
			 {
			  *(data_ptr4+ i) = myMsg.DATA[i];
			 }
		 } 
    #else
		//ssPrintf("windows\n");
		/* Read the CAN driver buffer */
		ret = CAN_Read((int)*PCAN_USBBUS[0],&myMsg,NULL);
		/* first entry is always the ret-value of the function */
		*(data_ptr0) = ret;  
		/* Accept only Data no Staus or Msg Type, also check if ret value was OK */
		if((ret == PCAN_ERROR_OK || ret == PCAN_ERROR_QRCVEMPTY) && ((myMsg.MSGTYPE==PCAN_MESSAGE_STANDARD)||(myMsg.MSGTYPE==PCAN_MESSAGE_EXTENDED)))
		{
			 *data_ptr1 = myMsg.ID;
			 *data_ptr2 = myMsg.MSGTYPE; 
			 *data_ptr3 = myMsg.LEN;
			 /* copy Data to Array */
			 for(i=0;i<myMsg.LEN;i++)
			 {
			  *(data_ptr4+ i) = myMsg.DATA[i];
			 }
		} 
     #endif 
}


/* Function: mdlTerminate =====================================================
 * Abstract:
 *    No termination needed, but we are required to have this routine.
 */
static void mdlTerminate(SimStruct *S)
{
}



#ifdef  MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif
