/*
  * File : PCAN_Write.c
 * Abstract:
 *     C-MEX S-function block for PCAN Write to CAN bus.
 *
 * References:
 *     PCANBasic.h
 *
 * Compile with:
 *     mex PCANBasic.lib PCAN_Write.c
 */


#define S_FUNCTION_NAME  PCAN_Write
#define S_FUNCTION_LEVEL 2

#include "simstruc.h"
#ifndef  MATLAB_MEX_FILE 
  #include <unistd.h>
  #include <math.h>
  #include <signal.h>
  #include <stdio.h>
  #include <stdlib.h>
  #include <fcntl.h>
  #include <string.h>
  #include <time.h>
  #include<PCANBasic.h>
#else
  #include <windows.h>
  #include "lib/PCANBasic.h"
  #include "mex.h"
#endif 


/*================*
 * Build checking *
 *================*/


/* Function: mdlInitializeSizes ===============================================
 * Abstract:
 *   Setup sizes of the various vectors.
 */
static void mdlInitializeSizes(SimStruct *S)
{
    ssSetNumSFcnParams(S, 0);
    if (ssGetNumSFcnParams(S) != ssGetSFcnParamsCount(S)) {
        return; /* Parameter mismatch will be reported by Simulink */
    }

    if (!ssSetNumInputPorts(S, 5)) return;
    ssSetInputPortWidth(S, 0, 1);//DYNAMICALLY_SIZED);
    ssSetInputPortWidth(S, 1, 1);//DYNAMICALLY_SIZED);
    ssSetInputPortWidth(S, 2, 1);//DYNAMICALLY_SIZED);
    ssSetInputPortWidth(S, 3, 1);//DYNAMICALLY_SIZED);
    ssSetInputPortWidth(S, 4, 8);//DYNAMICALLY_SIZED);
    ssSetInputPortDirectFeedThrough(S, 0, 1);

    if (!ssSetNumOutputPorts(S,1)) return;
    ssSetOutputPortWidth(S, 0, 1);//DYNAMICALLY_SIZED);

    ssSetNumSampleTimes(S, 1);

    /* Take care when specifying exception free code - see sfuntmpl_doc.c */
    ssSetOptions(S,
                 SS_OPTION_WORKS_WITH_CODE_REUSE |
                 SS_OPTION_EXCEPTION_FREE_CODE |
                 SS_OPTION_USE_TLC_WITH_ACCELERATOR);
}


/* Function: mdlInitializeSampleTimes =========================================
 * Abstract:
 *    Specifiy that we inherit our sample time from the driving block.
 */
static void mdlInitializeSampleTimes(SimStruct *S)
{
    ssSetSampleTime(S, 0, 0.02);
    ssSetOffsetTime(S, 0, 0.0);
    ssSetModelReferenceSampleTimeDefaultInheritance(S); 
}

/* Function: mdlOutputs =======================================================
 * Abstract:
 *   
 */
static void mdlOutputs(SimStruct *S, int_T tid)
{
	
    int_T             i, ret;
    TPCANMsg myMsg;
    InputRealPtrsType input = ssGetInputPortRealSignalPtrs(S,0);
    real_T            *y    = ssGetOutputPortRealSignal(S,0);
	#ifndef  MATLAB_MEX_FILE
		// running on HW
		// printf("linux\n");
		myMsg.ID = (int)*input[1];
		myMsg.MSGTYPE = (int)*input[2];
		myMsg.LEN = (int)*input[3];
		for(i=0; i<8; i++)
			myMsg.DATA[i] = (int)*input[i + 4];
		ret=CAN_Write((int)*input[0],&myMsg);
		*(y) = ret;  
	 #else
		//ssPrintf("windows\n");
		myMsg.ID = (int)*input[0];
		myMsg.MSGTYPE = (int)*input[1];
		myMsg.LEN = (int)*input[2];
		for(i=0; i<8; i++)
			myMsg.DATA[i] = (int)*input[i + 3];
		ret=CAN_Write((int)*input[0],&myMsg);
		*(y) = ret;  
	 #endif 
}


/* Function: mdlTerminate =====================================================
 * Abstract:
 *    No termination needed, but we are required to have this routine.
 */
static void mdlTerminate(SimStruct *S)
{
}



#ifdef  MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif

