function  [varargout] = CanLoad(varargin)
% CanLoad -- Loads a CANalyzer Data file into a Matlab Structure 
%
% CONFIDENTIAL FORD MOTOR COMPANY (see notice in .m source file)
%
% USAGE:
%   [cancel_button,test_name,can] = CanLoad(full_name)
%
% DESCRIPTION:
%   Uses the Common Open Dialog Box to load a CANAlyzer Data file
%   into a Matlab Structure.  Creates the following files in the data
%   directory:  can_module_ext.m, blf_matlab.mexw32 (blf file type only)
%   binlog.dll (blf file type only), GetAsciiMessageFilterList.m (asc file
%   type only)
%
% REQUIRED ARGUMENTS:
%   None
%
% OPTIONAL ARGUMENTS:
%   full_name - The name of the CANalyzer file to be translated.  File
%               types can be .blf, .mat, .asc or .dvl. If no
%               CANalyzer file is provided, the user will be presented
%               with a file selector box.
%
%   Version - (string) The string Version in order to return the Version of
%              the CanLoad function
%
% PROPERTIES:
%   None
%
% RETURN VALUE:
%   (logical) - cancel_button variable is either 1 or 0 based on whether or
%               not the user hit the cancel button in the file selector box.
%
%   (string) - test_name variable will return the name of the file analyzed
%
%   (structure) - can variable will return the CANalyzer data in a Matlab
%                 Structure 
%
% SIDE EFFECTS:
%   None   
%
% EXAMPLES:
%   % Read a data file and return data in a Matlab structure 
%   can = CanLoad('E:\data\MyData001.blf');
%
%   % Use the file selector box to pick a file
%   [cancel_button,test_name,can] = CanLoad;
%
%   % Retrieve the version number of the CanLoad function
%   CanLoad('Version')
%
% See also:
%   dbc2Module, dbc2ModuleBatch
% **************************************************************************
%
% AUTHOR:  Reid Steiger
% CREATED: 20081216
%
% HISTORY:
%
% 20081216 RJS -- Initial Release
%
% 20120314 RJS -- V 2012.03.14
%              -- Public Release
%
% 20130314 RJS -- V 2013.03.14
%              -- Public Release now supports blf decoding with 64-Bit
%                 Matlab
%
% 20130614 RJS -- V 2013.06.14
%              -- Changed the way BlfMatlab.mex V12.01.00 returns "data".
%                 Previous version only used 4 bytes for CAN Time
%                 New version uses 8 bytes for CAN Time 
%              -- Changed the size of the mex Matrix from 17 x N to 21 x N
%                 This was required to to change CAN Time from 4 to 8 Bytes
%              -- Upped the maximum number of CAN messages to 200 Million!
%
% **************************************************************************
%
% CONFIDENTIAL FORD MOTOR COMPANY
% This is an unpublished work of authorship, which contains trade secrets,
% created in 2009. Ford Motor Company owns all rights to this work and
% intends to maintain it in confidence to preserve its trade secret status.
% Ford Motor Company reserves the right, under the copyright laws of the
% United States or those of any other country that may have jurisdiction, to
% protect this work as an unpublished work, in the event of an inadvertent or
% deliberate unauthorized publication. Ford Motor Company also reserves its
% rights under all copyright laws to protect this work as a published work,
% when appropriate. Those having access to this work may not copy it, use it,
% or disclose the information contained in it without the written author-
% ization of Ford Motor Company.
%
% **************************************************************************